<x-user-layout :title="'Profile'">
    <div class="w-full mx-auto p-4 pb-24 md:pb-4 bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between mb-8 pb-4">
            <a href="{{ route('profile.edit') }}" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold text-center flex-1">Security Settings</h1>
            <div class="w-8"></div> <!-- Spacer for centering -->
        </div>

        <!-- Subtitle -->
        <p class="text-center text-gray-500 dark:text-gray-400 mb-8">Change or edit your password and passcode.</p>

        <!-- Success Message -->
        @if(session('success'))
            <div class="bg-green-100 text-green-700 p-4 rounded mb-6">
                {{ session('success') }}
            </div>
        @endif

        <!-- Error Messages -->
        @if($errors->any())
            <div class="bg-red-100 text-red-700 p-4 rounded mb-6">
                <ul class="list-disc pl-5">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <!-- Form -->
        <form method="POST" action="{{ route('profile.update') }}" class="max-w-md mx-auto space-y-6">
            @csrf
            @method('PATCH')

            <!-- Six Digit Passcode -->
            <div class="space-y-2">
                <label for="passcode" class="block text-sm font-medium text-gray-500 dark:text-gray-300">
                    Your Six Digit Passcode
                </label>
                <div class="relative">
                    <input 
                        type="password" 
                        id="passcode"
                        name="passcode"
                        maxlength="6"
                        class="w-full bg-gray-100 dark:bg-gray-800 border 
                            @error('passcode') border-red-500 @else border-gray-700 @enderror 
                            rounded-lg py-3 px-4 text-white placeholder-gray-400 
                            focus:outline-none focus:border-gray-600"
                        placeholder="Enter six-digit passcode"
                        value="{{ old('passcode') }}"
                        required
                    >
                    <button 
                        type="button"
                        aria-label="Toggle Passcode Visibility"
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-300 toggle-password"
                    >
                        <i class="fas fa-eye-slash"></i>
                    </button>
                </div>
                @error('passcode')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Current Password -->
            <div class="space-y-2">
                <label for="current-password" class="block text-sm font-medium text-gray-500 dark:text-gray-300">
                    Current Password
                </label>
                <div class="relative">
                    <input 
                        type="password" 
                        id="current-password"
                        name="current_password"
                        class="w-full bg-gray-100 dark:bg-gray-800 border 
                            @error('current_password') border-red-500 @else border-gray-700 @enderror 
                            rounded-lg py-3 px-4 text-white placeholder-gray-400 
                            focus:outline-none focus:border-gray-600"
                        placeholder="Enter current password"
                        required
                    >
                    <button 
                        type="button"
                        aria-label="Toggle Current Password Visibility"
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-300 toggle-password"
                    >
                        <i class="fas fa-eye-slash"></i>
                    </button>
                </div>
                @error('current_password')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- New Password -->
            <div class="space-y-2">
                <label for="new-password" class="block text-sm font-medium text-gray-500 dark:text-gray-300">
                    New Password
                </label>
                <div class="relative">
                    <input 
                        type="password" 
                        id="new-password"
                        name="password"
                        class="w-full bg-gray-100 dark:bg-gray-800 border 
                            @error('password') border-red-500 @else border-gray-700 @enderror 
                            rounded-lg py-3 px-4 text-white placeholder-gray-400 
                            focus:outline-none focus:border-gray-600"
                        placeholder="Enter new password"
                        required
                    >
                    <button 
                        type="button"
                        aria-label="Toggle New Password Visibility"
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-300 toggle-password"
                    >
                        <i class="fas fa-eye-slash"></i>
                    </button>
                </div>
                @error('password')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Confirm New Password -->
            <div class="space-y-2">
                <label for="confirm-password" class="block text-sm font-medium text-gray-500 dark:text-gray-300">
                    Confirm New Password
                </label>
                <div class="relative">
                    <input 
                        type="password" 
                        id="confirm-password"
                        name="password_confirmation"
                        class="w-full bg-gray-100 dark:bg-gray-800 border 
                            @error('password_confirmation') border-red-500 @else border-gray-700 @enderror 
                            rounded-lg py-3 px-4 text-white placeholder-gray-400 
                            focus:outline-none focus:border-gray-600"
                        placeholder="Confirm new password"
                        required
                    >
                    <button 
                        type="button"
                        aria-label="Toggle Confirm Password Visibility"
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-300 toggle-password"
                    >
                        <i class="fas fa-eye-slash"></i>
                    </button>
                </div>
                @error('password_confirmation')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Submit Button -->
            <button 
                type="submit"
                class="w-full bg-yellow-500 hover:bg-yellow-600 text-black font-semibold py-3 px-4 rounded-lg transition-colors mt-8"
            >
                Change Password
            </button>
        </form>
    </div>

    <script>
        // Toggle password visibility
        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('button.toggle-password').forEach(button => {
                button.addEventListener('click', function() {
                    const input = this.previousElementSibling;
                    const icon = this.querySelector('i');

                    if (input.type === 'password') {
                        input.type = 'text';
                        icon.classList.remove('fa-eye-slash');
                        icon.classList.add('fa-eye');
                    } else {
                        input.type = 'password';
                        icon.classList.remove('fa-eye');
                        icon.classList.add('fa-eye-slash');
                    }
                });
            });
        });
    </script>
</x-user-layout>
